const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_temp_master', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NA"
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    BMRNo: {
      type: DataTypes.STRING(150),
      allowNull: true
    },
    GraphType: {
      type: DataTypes.STRING(15),
      allowNull: true
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpQty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpFreq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BalanceId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    VernierId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    FriabilityID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    HardnessID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    SideNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Nom: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTol: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosNet: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosNetActual: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    ReportType: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "0"
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true
    },
    NoOfAbove1: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    NoOfBelow1: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    NoOfAbove2: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    NoOfBelow2: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MinPer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPer: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    GroupWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    AvgNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeightEmpty: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MaxWeightNet: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    StdDev: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    FailedRemarkTSH: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Deviation: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Nom_stdtarget: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TotalWeight: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    MinGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgGrpWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Test_Seq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    MPN_Code: {
      type: DataTypes.STRING(300),
      allowNull: true,
      defaultValue: "NULL"
    },
  }, {
    sequelize,
    tableName: 'tbl_temp_master',
    timestamps: false
  });
  seq.removeAttribute('id');
  return seq;
};
